package ru.yandex.qe.dispenser.domain.util.clickhouse;

public enum ClickHouseDataTypeFactory {
    U8("UInt8"),
    U16("UInt16"),
    U32("UInt32"),
    U64("UInt64"),
    I8("Int8"),
    I16("Int16"),
    I32("Int32"),
    I64("Int64"),
    F32("Float32"),
    F64("Float64"),
    STRING("String"),
    DATE("Date"),
    DATE_TIME("DateTime"),
    FIXED_STRING("FixedString");

    private final String name;

    ClickHouseDataTypeFactory(final String name) {
        this.name = name;
    }

    public ClickHouseDataType create(final Object... params) {
        switch (this) {
            case U8:
            case U16:
            case U32:
            case U64:
            case I8:
            case I16:
            case I32:
            case I64:
            case F32:
            case F64:
            case STRING:
            case DATE:
            case DATE_TIME:
                if (params.length != 0) {
                    throw new ClickHouseClientException(this.name + " doesn't support parameters!");
                }
                return new ClickHouseDataType(this.name);
            case FIXED_STRING:
                if (params.length != 1 || !(params[0] instanceof Integer)) {
                    throw new ClickHouseClientException(this.name + " supports exactly one parameter!");
                }
                return new ClickHouseDataType(String.format("%1$s(%2$d)", this.name, params[0]));
            default:
                throw new ClickHouseClientException("Unknown ClickHouseDataTypeFactory enum constant!");
        }
    }
}
