package ru.yandex.qe.dispenser.domain.util.clickhouse;

public final class ClickHouseEngine {

    private final String engine;

    ClickHouseEngine(final String engine) {
        this.engine = engine;
    }

    public String name() {
        return engine;
    }

    @Override
    public String toString() {
        return engine;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }

        final ClickHouseEngine that = (ClickHouseEngine) o;

        return engine.equals(that.engine);

    }

    @Override
    public int hashCode() {
        return engine.hashCode();
    }
}
