package ru.yandex.qe.dispenser.domain.util.clickhouse;

import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Arrays;
import java.util.stream.Collectors;

import org.apache.commons.lang3.StringUtils;

public abstract class InsertDataProvider extends InputStream {

    private static final String[] CHARS = {"\\", "\n", "\t"};
    private static final String[] ESCAPE = {"\\\\", "\\n", "\\t"};

    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss");
    private static final DateTimeFormatter DATE_FORMATTER = DateTimeFormatter.ofPattern("yyyy-MM-dd");

    private byte[] currentBuffer = new byte[0];
    private int currentIndex = 0;

    protected final String escape(final String str) {
        return StringUtils.replaceEach(str, CHARS, ESCAPE);
    }

    protected final byte[] fieldsToBytes(final String... strs) {
        try {
            return (Arrays.stream(strs).map(this::escape).collect(Collectors.joining("\t")) + "\n").getBytes("utf-8");
        } catch (UnsupportedEncodingException ignore) {
            return new byte[0];
        }
    }

    protected final String formatDate(final LocalDateTime dt) {
        return dt.format(DATE_FORMATTER);
    }

    protected final String formatDateTime(final LocalDateTime dt) {
        return dt.format(DATE_TIME_FORMATTER);
    }

    protected abstract byte[] next();

    protected abstract boolean hasNext();

    @Override
    public final int read() {
        if (!hasNext() && currentBuffer.length == currentIndex) {
            return -1;
        }
        if (currentBuffer.length == currentIndex) {
            currentBuffer = next();
            currentIndex = 0;
        }
        return currentBuffer[currentIndex++];
    }

}
