package ru.yandex.qe.dispenser.solomon;

import javax.inject.Inject;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

import ru.yandex.monlib.metrics.JvmGc;
import ru.yandex.monlib.metrics.JvmMemory;
import ru.yandex.monlib.metrics.JvmRuntime;
import ru.yandex.monlib.metrics.JvmThreads;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

@Component("solomonHolder")
public class SolomonHolder {

    private final MetricRegistry rootRegistry = new MetricRegistry();
    private final long solomonTvmId;

    @Inject
    public SolomonHolder(@Value("${solomon.tvm.id}") final long solomonTvmId) {
        this.solomonTvmId = solomonTvmId;
        JvmRuntime.addMetrics(rootRegistry);
        JvmMemory.addMetrics(rootRegistry);
        JvmGc.addMetrics(rootRegistry);
        JvmThreads.addMetrics(rootRegistry);
    }

    public MetricRegistry getRootRegistry() {
        return rootRegistry;
    }

    public long getSolomonTvmId() {
        return solomonTvmId;
    }

}
