JAVA_LIBRARY(dispenser-domain)

OWNER(g:dispenser)

INCLUDE(${ARCADIA_ROOT}/intranet/dispenser/dispenser-service/server/server.inc)

PEERDIR(
    intranet/dispenser/dispenser-service/api
    intranet/dispenser/dispenser-service/client
    intranet/dispenser/dispenser-service/lib/commons-json
    intranet/dispenser/dispenser-service/lib/commons-http-telemetry
    intranet/dispenser/dispenser-service/lib/commons-util-io
    intranet/dispenser/dispenser-service/lib/commons-util-lang
    intranet/dispenser/dispenser-service/lib/commons-util-collection
    intranet/dispenser/dispenser-service/lib/commons-logging
    intranet/dispenser/dispenser-service/lib/commons-spring
    library/java/monlib/metrics
    library/java/monlib/metrics-jvm
    intranet/dispenser/dispenser-service/lib/goals-client #todo use code from tracker

    contrib/java/org/postgresql/postgresql
    contrib/java/org/apache/commons/commons-dbcp2
    contrib/java/org/apache/commons/commons-text
    contrib/java/org/springframework/retry/spring-retry
    contrib/java/org/flywaydb/flyway-core
    contrib/java/com/healthmarketscience/sqlbuilder/sqlbuilder
    contrib/java/com/mchange/c3p0
    contrib/java/javax/mail/mail
    contrib/java/com/sun/activation/jakarta.activation
    contrib/java/org/apache/httpcomponents/httpcore
    contrib/java/org/apache/httpcomponents/httpclient
    contrib/java/org/apache/httpcomponents/fluent-hc
    contrib/java/org/apache/cxf/cxf-rt-rs-client
    contrib/java/com/fasterxml/jackson/jaxrs/jackson-jaxrs-json-provider
    contrib/java/org/springframework/spring-context-support
    contrib/java/io/github/resilience4j/resilience4j-kotlin
    contrib/java/io/github/resilience4j/resilience4j-retry
    contrib/java/org/jetbrains/kotlinx/kotlinx-coroutines-slf4j
    contrib/java/io/github/microutils/kotlin-logging-jvm

    tracker/tracker-java-client/tracker-client/src/main
    iceberg/bolts
)

EXCLUDE(
    contrib/java/javax/activation/activation
    contrib/java/commons-collectios/commons-collections
    contrib/java/log4j/log4j
    contrib/java/org/ow2/asm/asm-all
)

JDK_VERSION(17)

JAVAC_FLAGS(
    -parameters
)

KOTLINC_FLAGS(
    -java-parameters
)

WITH_KOTLIN()

JAVA_SRCS(SRCDIR src/main/java **/*.java)
JAVA_SRCS(SRCDIR src/main/java **/*.kt)
JAVA_SRCS(SRCDIR src/main/resources **/*)

NO_LINT()
CHECK_JAVA_DEPS(yes)
JAVA_DEPENDENCIES_CONFIGURATION(REQUIRE_DM FORBID_DEFAULT_VERSIONS FORBID_CONFLICT)

END()

RECURSE_FOR_TESTS(
    src/test
)
