package ru.yandex.qe.dispenser.flyway;

import java.util.AbstractMap;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.Nonnull;
import javax.inject.Inject;

import com.google.common.base.Preconditions;

import ru.yandex.qe.spring.PropertyResolverBean;

public class FlywayPlaceholderResolver implements Map<String, String> {

    private PropertyResolverBean propertyResolverBean;

    @Inject
    public void setPropertyResolverBean(PropertyResolverBean propertyResolverBean) {
        this.propertyResolverBean = propertyResolverBean;
    }

    @Override
    public int size() {
        return propertyResolverBean.getPropertyNames().size();
    }

    @Override
    public boolean isEmpty() {
        return propertyResolverBean.getPropertyNames().isEmpty();
    }

    @Override
    public boolean containsKey(Object key) {
        Preconditions.checkNotNull(key);
        return propertyResolverBean.getPropertyNames().contains(key.toString());
    }

    @Override
    public boolean containsValue(Object value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String get(Object key) {
        Preconditions.checkNotNull(key);
        return propertyResolverBean.getPropertyValue(key.toString());
    }

    @Override
    public String put(String key, String value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String remove(Object key) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void putAll(@Nonnull Map<? extends String, ? extends String> m) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void clear() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Set<String> keySet() {
        return new HashSet<>(propertyResolverBean.getPropertyNames());
    }

    @Override
    @Nonnull
    public Collection<String> values() {
        throw new UnsupportedOperationException();
    }

    @Override
    @Nonnull
    public Set<Entry<String, String>> entrySet() {
        return keySet().stream().map(key -> new AbstractMap.SimpleEntry<>(key, get(key)))
                .collect(Collectors.toSet());
    }
}
