package ru.yandex.qe.jetty.server;

import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Required;

import javax.annotation.PostConstruct;
import javax.servlet.Servlet;

public class ServletRegistrator implements FactoryBean<Servlet> {

    @Autowired
    ServletContextHandler servletContextHandler;

    private ServletHolder servletHolder;

    private String servletPath;

    @Required
    public void setServletHolder(ServletHolder servletHolder) {
        this.servletHolder = servletHolder;
    }

    @Required
    public void setServletPath(String servletPath) {
        this.servletPath = servletPath;
    }

    @PostConstruct
    public void init() {
        servletContextHandler.addServlet(servletHolder, servletPath);
    }

    @Override
    public Servlet getObject() throws Exception {
        return servletHolder.getServlet();
    }

    @Override
    public Class<?> getObjectType() {
        return Servlet.class;
    }

    @Override
    public boolean isSingleton() {
        return true;
    }
}
