START TRANSACTION;

CREATE TABLE IF NOT EXISTS resource_group (
  id         bigserial PRIMARY KEY,
  key        short_text NOT NULL,
  name       short_text NOT NULL,
  service_id bigint     NOT NULL REFERENCES service (id) ON UPDATE CASCADE ON DELETE CASCADE,
  UNIQUE (key)
);

ALTER TABLE resource ADD IF NOT EXISTS resource_group_id bigint REFERENCES resource_group(id) ON UPDATE CASCADE ON DELETE SET NULL;

CREATE INDEX IF NOT EXISTS resource_resource_group_id_ix ON resource (resource_group_id);


INSERT INTO resource_group (key, name, service_id)
SELECT 'nirvana-workflows', 'Нирвана: графы', id
FROM service
WHERE service.key = 'nirvana';

UPDATE resource
SET resource_group_id = currval('resource_group_id_seq')
WHERE key IN ('workflow-create', 'workflow-start', 'workflow-block-start');


INSERT INTO resource_group (key, name, service_id)
SELECT 'nirvana-storage', 'Нирвана: хранилище', id
FROM service
WHERE service.key = 'nirvana';

UPDATE resource
SET resource_group_id = currval('resource_group_id_seq')
WHERE key IN ('yt-disk');


INSERT INTO resource_group (key, name, service_id)
SELECT 'nirvana-computational-cpu', 'Нирвана: вычислительные ресурсы в YT для CPU-задач', id
FROM service
WHERE service.key = 'nirvana';

UPDATE resource
SET resource_group_id = currval('resource_group_id_seq')
WHERE key IN ('yt-cpu', 'yt-ram');


INSERT INTO resource_group (key, name, service_id)
SELECT 'nirvana-computational-gpu', 'Нирвана: вычислительные ресурсы в YT для GPU-задач', id
FROM service
WHERE service.key = 'nirvana';

UPDATE resource
SET resource_group_id = currval('resource_group_id_seq')
WHERE key IN (
    'tesla-k40-gpu', 'tesla-k40-cpu', 'tesla-k40-ram',
    'tesla-m40-gpu', 'tesla-m40-cpu', 'tesla-m40-ram',
    'geforce-1080ti-gpu', 'geforce-1080ti-cpu', 'geforce-1080ti-ram',
    'tesla-p40-gpu', 'tesla-p40-cpu', 'tesla-p40-ram',
    'tesla-v100-gpu', 'tesla-v100-cpu', 'tesla-v100-ram');


INSERT INTO resource_group (key, name, service_id)
SELECT 'nirvana-yt-operations', 'Нирвана: операции в YT', id
FROM service
WHERE service.key = 'nirvana';

UPDATE resource
SET resource_group_id = currval('resource_group_id_seq')
WHERE key IN ('yt-operations-total', 'yt-operations-running');


INSERT INTO resource_group (key, name, service_id)
SELECT 'crhn', 'Нирвана: вычислительные ресурсы в JobAPI', id
FROM service
WHERE service.key = 'cluster-api';

UPDATE resource
SET resource_group_id = currval('resource_group_id_seq')
WHERE key IN ('cpu', 'ram');


INSERT INTO resource_group (key, name, service_id)
SELECT 'gpu', 'GPU', id
FROM service
WHERE service.key = 'cluster-api';

UPDATE resource
SET resource_group_id = currval('resource_group_id_seq')
WHERE key IN ('cuda-3-5', 'cuda-5-2', 'cuda-6-1', 'cuda-7-0');


INSERT INTO resource_group (key, name, service_id)
SELECT 'scraper-production', 'Scraper Продакшен', id
FROM service
WHERE service.key = 'scraper';

UPDATE resource
SET resource_group_id = currval('resource_group_id_seq')
WHERE key IN ('production-monitoring-requests', 'production-kpi-requests', 'production-other-requests');


INSERT INTO resource_group (key, name, service_id)
SELECT 'scraper-priemka-vm', 'Scraper Priemka-vm', id
FROM service
WHERE service.key = 'scraper';

UPDATE resource
SET resource_group_id = currval('resource_group_id_seq')
WHERE key IN
      ('priemka-vm-monitoring-requests', 'priemka-vm-kpi-requests', 'priemka-vm-acceptance-requests', 'priemka-vm-other-requests');


INSERT INTO resource_group (key, name, service_id)
SELECT 'scraper-hamster', 'Scraper Hamster', id
FROM service
WHERE service.key = 'scraper';

UPDATE resource
SET resource_group_id = currval('resource_group_id_seq')
WHERE key IN ('hamster-monitoring-requests', 'hamster-acceptance-requests', 'hamster-prs-requests', 'hamster-other-requests');


INSERT INTO resource_group (key, name, service_id)
SELECT 'scraper-other', 'Scraper Остальное', id
FROM service WHERE service.key = 'scraper';

UPDATE resource
SET resource_group_id = currval('resource_group_id_seq')
WHERE key IN ('created-batches', 'yandex-other-requests', 'not-yandex-kpi-requests', 'not-yandex-other-requests');


INSERT INTO resource_group (key, name, service_id)
SELECT 'screenshot', 'Скриншоты', id
FROM service WHERE service.key = 'scraper';

UPDATE resource SET resource_group_id = currval ('resource_group_id_seq')
WHERE key IN ('tellurium-screenshots', 'beauty-screen-screenshots', 'casper-document-screenshots');


INSERT INTO resource_group (key, name, service_id)
SELECT 'scraper-admin', 'Техническая информация', id
FROM service WHERE service.key = 'scraper';

UPDATE resource
SET resource_group_id = currval('resource_group_id_seq')
WHERE key IN ('get-batch-status-count', 'serps-without-resources-count', 'tellurium-parallel', 'beauty-screen-parallel', 'casper-parallel', 'smeh-parallel');


COMMIT;
