START TRANSACTION;

INSERT INTO resource_group (key, name, service_id)
SELECT 'nirvana-computational-cpu-nirvana-tree' as key, 'Нирвана: вычислительные ресурсы в YT для CPU-задач (дерево nirvana)' as name, service_id FROM resource_group WHERE key = 'nirvana-computational-cpu'
ON CONFLICT DO NOTHING;


INSERT INTO resource (key, service_id, name, resource_type, description, quoting_mode, resource_group_id)
SELECT 'yt-cpu-nir' as key, r.service_id, r.name, r.resource_type, 'CPU в YT (nirvana)' as description, r.quoting_mode, rg.id as resource_group_id
FROM resource r, resource_group rg
WHERE r.key = 'yt-cpu' and rg.key = 'nirvana-computational-cpu-nirvana-tree'
ON CONFLICT DO NOTHING;

INSERT INTO quota_spec (key, resource_id, description, value_type)
SELECT 'yt-cpu-nir-quota' as key, r.id as resource_id, 'Квота на CPU в YT (nirvana)' as description, qs.value_type FROM resource r, quota_spec qs 
WHERE r.key = 'yt-cpu-nir' AND qs.key = 'yt-cpu-quota'
ON CONFLICT DO NOTHING;

INSERT INTO quota (quota_spec_id, project_id, max_value, actual_value)
SELECT qs.id as quota_spec_id, p.id as project_id, 0 as max_value, 0 as actual_value FROM project p, quota_spec qs
WHERE qs.key = 'yt-cpu-nir-quota'
ON CONFLICT DO NOTHING;

INSERT INTO resource (key, service_id, name, resource_type, description, quoting_mode, resource_group_id)
SELECT 'yt-ram-nir' as key, r.service_id, r.name, r.resource_type, 'RAM в YT (nirvana)' as description, r.quoting_mode, rg.id as resource_group_id
FROM resource r, resource_group rg
WHERE r.key = 'yt-ram' and rg.key = 'nirvana-computational-cpu-nirvana-tree'
ON CONFLICT DO NOTHING;

INSERT INTO quota_spec (key, resource_id, description, value_type)
SELECT 'yt-ram-nir-quota' as key, r.id as resource_id, 'Квота на RAM в YT (nirvana)' as description, qs.value_type FROM resource r, quota_spec qs 
WHERE r.key = 'yt-ram-nir' AND qs.key = 'yt-ram-quota'
ON CONFLICT DO NOTHING;

INSERT INTO quota (quota_spec_id, project_id, max_value, actual_value)
SELECT qs.id as quota_spec_id, p.id as project_id, 0 as max_value, 0 as actual_value FROM project p, quota_spec qs
WHERE qs.key = 'yt-ram-nir-quota'
ON CONFLICT DO NOTHING;


UPDATE resource_group SET name = 'Нирвана: вычислительные ресурсы в YT для CPU-задач (дерево physical)', key = 'nirvana-computational-cpu-physical-tree' WHERE key = 'nirvana-computational-cpu';

COMMIT;

