START TRANSACTION;

CREATE TYPE quota_request_status AS ENUM ('NEW', 'CANCELLED', 'REJECTED', 'APPLIED');

CREATE TABLE quota_request (
  id          BIGSERIAL PRIMARY KEY,
  quota_id    BIGINT               NOT NULL REFERENCES quota (id) ON UPDATE CASCADE ON DELETE CASCADE,
  author_id   BIGINT               NOT NULL REFERENCES person (id) ON UPDATE CASCADE,
  amount      BIGINT               NOT NULL CHECK (amount >= 0),
  description TEXT                 NOT NULL,
  status      quota_request_status NOT NULL,
  ticket_key  short_text,
  created     timestamp            NOT NULL,
  updated     timestamp            NOT NULL
);

COMMIT;
