START TRANSACTION;

CREATE TABLE quota_request_change
(
  id               BIGSERIAL PRIMARY KEY,
  quota_request_id BIGINT NOT NULL REFERENCES quota_request (id) ON UPDATE CASCADE ON DELETE CASCADE,
  resource_id      BIGINT NOT NULL REFERENCES resource (id) ON UPDATE CASCADE ON DELETE CASCADE,
  amount           BIGINT NOT NULL CHECK (amount >= 0)
);

CREATE TABLE quota_request_change_segment
(
  quota_request_change_id BIGINT NOT NULL REFERENCES quota_request_change ON UPDATE CASCADE ON DELETE CASCADE,
  segment_id              BIGINT NOT NULL REFERENCES segment ON UPDATE CASCADE ON DELETE CASCADE,
  UNIQUE (quota_request_change_id, segment_id)
);

ALTER TABLE quota_request
  ADD COLUMN project_id BIGINT REFERENCES project (id) ON UPDATE CASCADE ON DELETE CASCADE;

ALTER TABLE quota_request
  ADD COLUMN service_id BIGINT REFERENCES service (id) ON UPDATE CASCADE ON DELETE CASCADE;

UPDATE quota_request
SET project_id = quota.project_id,
    service_id = resource.service_id
FROM quota,
     quota_spec,
     resource
WHERE quota.id = quota_request.quota_id
  AND quota.quota_spec_id = quota_spec.id
  AND quota_spec.resource_id = resource.id;

ALTER TABLE quota_request
  ALTER COLUMN project_id SET NOT NULL;

ALTER TABLE quota_request
  ALTER COLUMN service_id SET NOT NULL;

INSERT INTO quota_request_change (quota_request_id, resource_id, amount)
SELECT quota_request.id, quota_spec.resource_id, quota_request.amount
FROM quota_request,
     quota,
     quota_spec
WHERE quota.id = quota_request.quota_id
  and quota_spec.id = quota.quota_spec_id;

INSERT INTO quota_request_change_segment(quota_request_change_id, segment_id)
SELECT quota_request.id, quota_segment.segment_id
FROM quota_request,
     quota_request_change,
     quota_segment
WHERE quota_segment.quota_id = quota_request.quota_id
  AND quota_request_change.quota_request_id = quota_request.id
  AND quota_segment.segment_id IS NOT NULL;

ALTER TABLE quota_request
  DROP COLUMN quota_id;

ALTER TABLE quota_request
  DROP COLUMN amount;

COMMIT;