START TRANSACTION;

ALTER TYPE quota_request_status
    RENAME TO _quota_request_status;

CREATE TYPE quota_request_status AS ENUM ('NEW', 'CANCELLED', 'REJECTED', 'APPLIED', 'CONFIRMED');

ALTER TABLE quota_request
    ALTER COLUMN status TYPE quota_request_status USING status :: text :: quota_request_status;

DROP TYPE _quota_request_status;

ALTER TYPE quota_request_type
    RENAME TO _quota_request_type;

CREATE TYPE quota_request_type AS ENUM ('QUOTA_INCREASE', 'RESOURCE_PREORDER', 'QUOTA_MOVE');

ALTER TABLE quota_request
    ALTER COLUMN type TYPE quota_request_type USING CASE
                                                        WHEN (type = 'RESOURCE') THEN 'RESOURCE_PREORDER'
                                                        ELSE type :: text :: quota_request_type END;

DROP TYPE _quota_request_type;


CREATE TABLE quota_request_approver
(
    request_id bigint REFERENCES quota_request (id) ON UPDATE CASCADE ON DELETE CASCADE,
    person_id  bigint REFERENCES person (id) ON UPDATE CASCADE ON DELETE CASCADE,
    approved   boolean NOT NULL DEFAULT FALSE,
    UNIQUE (request_id, person_id)
);

COMMIT;