START TRANSACTION;

CREATE TYPE property_type AS ENUM ('BOOLEAN');

CREATE TABLE property
(
    id           BIGSERIAL PRIMARY KEY,
    entity_key   SHORT_TEXT    NOT NULL,
    property_key SHORT_TEXT    NOT NULL,
    type         property_type NOT NULL,

    UNIQUE (entity_key, property_key)
);

CREATE TABLE property_boolean_value
(
    property_id BIGINT PRIMARY KEY REFERENCES property (id) ON UPDATE CASCADE,
    value       BOOLEAN NOT NULL
);

COMMIT;
