START TRANSACTION;

CREATE TABLE bot_pre_order
(
    id                      BIGINT PRIMARY KEY,
    project_id              BIGINT NOT NULL REFERENCES project (id) ON UPDATE CASCADE ON DELETE CASCADE,
    service_id              BIGINT NOT NULL REFERENCES service (id) ON UPDATE CASCADE ON DELETE CASCADE,
    bot_big_order_id        BIGINT NOT NULL REFERENCES bot_big_order (id) ON UPDATE CASCADE ON DELETE CASCADE,
    bot_big_order_config_id BIGINT NOT NULL,
    server_id               BIGINT NULL,
    server_quantity         BIGINT NULL,
    storage_id              BIGINT NULL,
    storage_quantity        BIGINT NULL,

    UNIQUE (project_id, service_id, bot_big_order_id, bot_big_order_config_id, server_id, storage_id)
);

CREATE TABLE bot_pre_order_change
(
    quota_request_change_id BIGINT NOT NULL REFERENCES quota_request_change (id) ON UPDATE CASCADE ON DELETE CASCADE,
    bot_pre_order_id        BIGINT NOT NULL REFERENCES bot_pre_order (id) ON UPDATE CASCADE ON DELETE CASCADE,

    UNIQUE (quota_request_change_id, bot_pre_order_id)
);

COMMIT;
