START TRANSACTION;

-- cant run ALTER TYPE inside transaction block
-- ALTER TYPE resource_type ADD VALUE 'BINARY_TRAFFIC' AFTER 'TRAFFIC';

-- cant run, no permissions
-- INSERT INTO pg_enum (enumtypid, enumlabel, enumsortorder)
--     SELECT 'resource_type'::regtype::oid, 'BINARY_TRAFFIC', ( SELECT MAX(enumsortorder) + 1 FROM pg_enum WHERE enumtypid = 'resource_type'::regtype );

ALTER TYPE resource_type
    RENAME TO _resource_type;

CREATE TYPE resource_type AS ENUM ('ENUMERABLE', 'MEMORY', 'MONEY', 'POWER', 'STORAGE', 'TRAFFIC', 'BINARY_TRAFFIC', 'PROCESSOR');

ALTER TABLE resource
    ALTER COLUMN resource_type TYPE resource_type USING resource_type :: text :: resource_type;

DROP TYPE _resource_type;

UPDATE resource
SET resource_type = 'BINARY_TRAFFIC'
FROM service
WHERE service.id = resource.service_id
  AND ((service.key = 'rtmr' AND resource.resource_type = 'TRAFFIC') OR
       (service.key = 'yt' AND resource.resource_type = 'TRAFFIC'));

COMMIT;