START TRANSACTION;

ALTER TABLE campaign ADD COLUMN IF NOT EXISTS request_creation_disabled BOOLEAN NOT NULL DEFAULT FALSE;
ALTER TABLE campaign ADD COLUMN IF NOT EXISTS request_modification_disabled_for_non_managers BOOLEAN NOT NULL DEFAULT FALSE;

CREATE INDEX IF NOT EXISTS campaign_status_index ON campaign (status);

ALTER TABLE quota_request ADD COLUMN IF NOT EXISTS campaign_id BIGINT REFERENCES campaign (id) ON UPDATE CASCADE ON DELETE CASCADE;

CREATE INDEX IF NOT EXISTS quota_request_campaign_big_order_index ON quota_request (campaign_id, order_id);
CREATE INDEX IF NOT EXISTS quota_request_big_order_index ON quota_request (order_id);
CREATE INDEX IF NOT EXISTS quota_request_author_index ON quota_request (author_id);
CREATE INDEX IF NOT EXISTS quota_request_status_index ON quota_request (status);
CREATE INDEX IF NOT EXISTS quota_request_type_index ON quota_request (type);
CREATE INDEX IF NOT EXISTS quota_request_project_index ON quota_request (project_id);
CREATE INDEX IF NOT EXISTS quota_request_service_index ON quota_request (service_id);
CREATE INDEX IF NOT EXISTS quota_request_ticket_key_index ON quota_request (ticket_key);

UPDATE quota_request SET campaign_id = (SELECT id as campaign_id FROM campaign WHERE key = 'aug2018') WHERE order_id = 37 AND campaign_id IS NULL AND type = cast('RESOURCE_PREORDER' AS quota_request_type);
UPDATE quota_request SET campaign_id = (SELECT id as campaign_id FROM campaign WHERE key = 'aug2019') WHERE order_id IN (39, 40, 41) AND campaign_id IS NULL AND type = cast('RESOURCE_PREORDER' AS quota_request_type);
UPDATE quota_request SET campaign_id = (SELECT c.id as campaign_id FROM campaign c JOIN campaign_big_order bo ON c.id = bo.campaign_id WHERE bo.big_order_id = quota_request.order_id ORDER BY c.id DESC LIMIT 1) WHERE campaign_id IS NULL AND order_id IS NOT NULL AND type = cast('RESOURCE_PREORDER' AS quota_request_type);

ALTER TABLE quota_request DROP CONSTRAINT IF EXISTS quota_request_has_order_for_preorder_constraint;
ALTER TABLE quota_request ADD CONSTRAINT quota_request_has_order_for_preorder_constraint CHECK ((order_id IS NOT NULL OR type != cast('RESOURCE_PREORDER' AS quota_request_type)) AND (order_id IS NULL OR type = cast('RESOURCE_PREORDER' AS quota_request_type)));

ALTER TABLE quota_request DROP CONSTRAINT IF EXISTS quota_request_has_campaign_for_preorder_constraint;
ALTER TABLE quota_request ADD CONSTRAINT quota_request_has_campaign_for_preorder_constraint CHECK ((campaign_id IS NOT NULL OR type != cast('RESOURCE_PREORDER' AS quota_request_type)) AND (campaign_id IS NULL OR type = cast('RESOURCE_PREORDER' AS quota_request_type)));

COMMIT;