START TRANSACTION;

ALTER TABLE campaign ADD COLUMN IF NOT EXISTS bot_pre_order_issue_key short_text;

UPDATE campaign set bot_pre_order_issue_key = 'DISPENSERREQ-3518' WHERE key = 'aug2018' AND bot_pre_order_issue_key IS NULL;
UPDATE campaign set bot_pre_order_issue_key = 'DISPENSERREQ-3358' WHERE key = 'aug2019' AND bot_pre_order_issue_key IS NULL;
UPDATE campaign set bot_pre_order_issue_key = '' WHERE bot_pre_order_issue_key IS NULL;

ALTER TABLE campaign ALTER COLUMN bot_pre_order_issue_key SET NOT NULL;

ALTER TABLE bot_pre_order ADD COLUMN IF NOT EXISTS campaign_id BIGINT REFERENCES campaign (id) ON UPDATE CASCADE ON DELETE CASCADE;

UPDATE bot_pre_order SET campaign_id = (SELECT id as campaign_id FROM campaign WHERE key = 'aug2018') WHERE bot_big_order_id = 37 AND campaign_id IS NULL;
UPDATE bot_pre_order SET campaign_id = (SELECT id as campaign_id FROM campaign WHERE key = 'aug2019') WHERE bot_big_order_id IN (39, 40, 41) AND campaign_id IS NULL;
UPDATE bot_pre_order SET campaign_id = (SELECT sub.ci AS id FROM (SELECT bpoc.bot_pre_order_id AS bpoi, qr.campaign_id AS ci FROM bot_pre_order AS bpo LEFT JOIN bot_pre_order_change AS bpoc ON bpo.id = bpoc.bot_pre_order_id LEFT JOIN quota_request_change qrc ON qrc.id = bpoc.quota_request_change_id LEFT JOIN quota_request qr ON qr.id = qrc.quota_request_id GROUP BY bpoi, ci) sub WHERE sub.bpoi = bot_pre_order.bot_big_order_id ORDER BY sub.ci DESC LIMIT 1) WHERE campaign_id IS NULL;

ALTER TABLE bot_pre_order ALTER COLUMN campaign_id SET NOT NULL;

ALTER TABLE bot_pre_order DROP CONSTRAINT bot_pre_order_project_id_service_id_bot_big_order_id_bot_bi_key;
ALTER TABLE bot_pre_order ADD UNIQUE (campaign_id, bot_big_order_id, project_id, service_id, bot_big_order_config_id, server_id, storage_id, group_key);

DROP INDEX bot_pre_order_server_storage_null;
CREATE UNIQUE INDEX bot_pre_order_server_storage_null ON bot_pre_order(campaign_id, bot_big_order_id, project_id, service_id, bot_big_order_config_id, group_key) WHERE storage_id IS NULL AND server_id IS NULL;

DROP INDEX bot_pre_order_storage_null;
CREATE UNIQUE INDEX bot_pre_order_storage_null ON bot_pre_order(campaign_id, bot_big_order_id, project_id, service_id, bot_big_order_config_id, group_key, server_id) WHERE storage_id IS NULL;

DROP INDEX bot_pre_order_server_null;
CREATE UNIQUE INDEX bot_pre_order_server_null ON bot_pre_order(campaign_id, bot_big_order_id, project_id, service_id, bot_big_order_config_id, group_key, storage_id) WHERE server_id IS NULL;

DELETE FROM property_boolean_value WHERE property_id IN (SELECT id FROM property WHERE entity_key = 'resource_preorder' AND property_key IN ('active', 'request_creation_active', 'request_responsible_updating_active'));
DELETE FROM property_string_value WHERE property_id IN (SELECT id FROM property WHERE entity_key = 'resource_preorder' AND property_key IN ('pre_order_ticket_2020', 'active_big_orders'));

DELETE FROM property WHERE entity_key = 'resource_preorder' AND property_key IN ('active', 'request_creation_active', 'request_responsible_updating_active', 'pre_order_ticket_2020', 'active_big_orders');

CREATE INDEX IF NOT EXISTS quota_request_updated_index ON quota_request (updated);

CREATE INDEX IF NOT EXISTS bot_pre_order_change_bot_pre_order_id_index ON bot_pre_order_change (bot_pre_order_id);

CREATE INDEX IF NOT EXISTS quota_request_change_quota_request_id_index ON quota_request_change (quota_request_id);

ALTER TABLE bot_service_reserve ADD COLUMN IF NOT EXISTS campaign_id BIGINT REFERENCES campaign (id) ON UPDATE CASCADE ON DELETE CASCADE;

UPDATE bot_service_reserve SET campaign_id = (SELECT id as campaign_id FROM campaign WHERE key = 'aug2018') WHERE big_order_id = 37 AND campaign_id IS NULL;
UPDATE bot_service_reserve SET campaign_id = (SELECT id as campaign_id FROM campaign WHERE key = 'aug2019') WHERE big_order_id IN (39, 40, 41) AND campaign_id IS NULL;
UPDATE bot_service_reserve SET campaign_id = (SELECT c.id as campaign_id FROM campaign c JOIN campaign_big_order bo ON c.id = bo.campaign_id WHERE bo.big_order_id = bot_service_reserve.big_order_id ORDER BY c.id DESC LIMIT 1) WHERE campaign_id IS NULL;

ALTER TABLE bot_service_reserve ALTER COLUMN campaign_id SET NOT NULL;

ALTER TABLE bot_service_reserve DROP CONSTRAINT bot_service_reserve_resource_id_segment_id_big_order_id_key;
ALTER TABLE bot_service_reserve ADD UNIQUE (campaign_id, big_order_id, resource_id, segment_id);

CREATE INDEX IF NOT EXISTS bot_service_reserve_big_order_id_index ON bot_service_reserve (big_order_id);
CREATE INDEX IF NOT EXISTS bot_service_reserve_resource_id_index ON bot_service_reserve (resource_id);
CREATE INDEX IF NOT EXISTS bot_service_reserve_segment_id_index ON bot_service_reserve (segment_id);

COMMIT;