START TRANSACTION;

CREATE TABLE request_goal
(
    id BIGSERIAL PRIMARY KEY,
    goal_id BIGINT REFERENCES goal (id) ON UPDATE CASCADE ON DELETE CASCADE,
    project_id BIGINT NOT NULL REFERENCES project (id) ON UPDATE CASCADE ON DELETE CASCADE,
    campaign_id  BIGINT NOT NULL REFERENCES campaign (id) ON UPDATE CASCADE ON DELETE CASCADE,
    data JSONB NOT NULL
);

CREATE UNIQUE INDEX request_goal_goal_null ON request_goal(project_id, campaign_id) WHERE goal_id IS NULL;
CREATE UNIQUE INDEX request_goal_goal_not_null ON request_goal(goal_id, project_id, campaign_id) WHERE goal_id IS NOT NULL;

-- 'GOAL' тип цель
-- 'GROWTH' тип естественный рост
-- 'NOTHING' без указания типа
CREATE TYPE resource_preorder_reason_type AS ENUM ('GOAL', 'GROWTH', 'NOTHING');

ALTER TABLE quota_request
    ADD COLUMN IF NOT EXISTS resource_preorder_reason_type resource_preorder_reason_type,
    ADD COLUMN IF NOT EXISTS goal_id BIGINT REFERENCES goal(id);

ALTER TABLE quota_request
    ADD CONSTRAINT check_goal_id check ( (type = 'RESOURCE_PREORDER' AND resource_preorder_reason_type = 'GOAL' AND goal_id IS NOT NULL)
        OR ((type != 'RESOURCE_PREORDER' OR resource_preorder_reason_type != 'GOAL') AND goal_id IS NULL) );

-- В старых заявках ставим тип "неизвестная цель"
UPDATE quota_request
SET resource_preorder_reason_type = 'NOTHING'
WHERE type = 'RESOURCE_PREORDER';

COMMIT;
