START TRANSACTION;

COMMENT ON TABLE bot_big_order IS 'Sync of big orders from the bot';
COMMENT ON TABLE bot_configuration IS 'Server Configurations Sync from the Bot';
COMMENT ON TABLE bot_pre_order IS 'Pre-orders. Sync to the bot';
COMMENT ON TABLE bot_pre_order_change IS 'Pre-order binding to quota_request_change';
COMMENT ON TABLE bot_service_configuration IS 'Providers binding to bot_configuration';
COMMENT ON TABLE bot_service_reserve IS 'Reserves. Not Used';
COMMENT ON TABLE campaign IS 'Campaign for resource pre-order';
COMMENT ON TABLE campaign_big_order IS 'Campaign binding to bot_big_order';
COMMENT ON TABLE dispenser_admin IS 'Dispenser admins';
COMMENT ON TABLE entity_spec IS 'For Nirvana. Entity that takes resources';
COMMENT ON TABLE entity_spec_resource IS 'entity_spec binding to resource';
COMMENT ON TABLE notification IS 'Information about the sent letters is stored';
COMMENT ON TABLE person IS 'persons, sync from the staff';
COMMENT ON TABLE person_membership IS 'Roles of persons, sync from the abc. On Nirvana cluster sync is off';
COMMENT ON TABLE project IS 'Projects (abc services), sync from the abc. On Nirvana cluster sync is off';
COMMENT ON TABLE project_service_meta IS 'Meta info for projects, used by providers. Only used on Nirvana cluster';
COMMENT ON TABLE property IS 'Stores values of properties for settings of instances';
COMMENT ON TABLE property_boolean_value IS 'The boolean values of the properties live here';
COMMENT ON TABLE property_string_value IS 'The string values of the properties live here';
COMMENT ON TABLE quota IS 'Presentation of a quota for spec / project';
COMMENT ON TABLE quota_request IS 'Requests on: move, pre-order, quota-increase live here';
COMMENT ON TABLE quota_request_approver IS 'Responsible for request and approval status. Deprecated';
COMMENT ON TABLE quota_request_change IS 'Resource Values in Requests';
COMMENT ON TABLE quota_request_change_segment IS 'quota_request_change binding to segment';
COMMENT ON TABLE quota_segment IS 'Quota segments';
COMMENT ON TABLE quota_spec IS 'Quota specification';
COMMENT ON TABLE request IS 'Answers on idempotent requests live here';
COMMENT ON TABLE resource IS 'Resources live here';
COMMENT ON TABLE resource_group IS 'Resource grouping';
COMMENT ON TABLE resource_segmentation IS 'Resource Segmentations';
COMMENT ON TABLE schema_version IS 'Flyway migration';
COMMENT ON TABLE segment IS 'Segment description';
COMMENT ON TABLE segmentation IS 'Segmentation description';
COMMENT ON TABLE service IS 'Services (Providers)';
COMMENT ON TABLE service_admin IS 'Service (Providers) Admins ';
COMMENT ON TABLE service_trustee IS 'Trusted Service (Providers) - Robots, etc.';
COMMENT ON TABLE yandex_group IS 'Groups';
COMMENT ON TABLE yandex_group_membership IS 'Group roles';

-- Func for add comments on Nirvana-special tables
CREATE FUNCTION add_comment_on_table("table" text, "comment" text) RETURNS void AS
$$
BEGIN
    IF EXISTS(SELECT relname FROM pg_class where relname = $1) THEN
        EXECUTE 'COMMENT ON TABLE "' || $1 || '" IS ' || quote_literal($2);
    END IF;
END
$$ LANGUAGE plpgsql;


DO
$$
    BEGIN
        PERFORM add_comment_on_table('entity', 'Table for created Nirvana entities');
        PERFORM add_comment_on_table('entity_cluster-api_workload', 'Table for created Nirvana entities');
        PERFORM add_comment_on_table('entity_cluster-api_workload-crhn', 'Table for created Nirvana entities');
        PERFORM add_comment_on_table('entity_nirvana_nirvana-workflow-create', 'Table for created Nirvana entities');
        PERFORM add_comment_on_table('entity_nirvana_nirvana-workflow-start', 'Table for created Nirvana entities');
        PERFORM add_comment_on_table('entity_nirvana_yt-file', 'Table for created Nirvana entities');
        PERFORM add_comment_on_table('entity_scraper_scraper-batch', 'Table for created Nirvana entities');
        PERFORM add_comment_on_table('entity_scraper_task', 'Table for created Nirvana entities');

        PERFORM add_comment_on_table('entity_usage', 'The amount of resources occupied by the entity');
        PERFORM add_comment_on_table('entity_usage_cluster-api_workload', 'The amount of resources occupied by the entity');
        PERFORM add_comment_on_table('entity_usage_cluster-api_workload-crhn', 'The amount of resources occupied by the entity');
        PERFORM add_comment_on_table('entity_usage_nirvana_nirvana-workflow-create', 'The amount of resources occupied by the entity');
        PERFORM add_comment_on_table('entity_usage_nirvana_nirvana-workflow-start', 'The amount of resources occupied by the entity');
        PERFORM add_comment_on_table('entity_usage_nirvana_yt-file', 'The amount of resources occupied by the entity');
        PERFORM add_comment_on_table('entity_usage_scraper_scraper-batch', 'The amount of resources occupied by the entity');
        PERFORM add_comment_on_table('entity_usage_scraper_task', 'The amount of resources occupied by the entity');

        PERFORM add_comment_on_table('cluster_state', 'Table for linking scrapper instances');
    end;
$$;

DROP FUNCTION add_comment_on_table;

COMMIT;