START TRANSACTION;

ALTER TABLE person ALTER COLUMN is_robot SET NOT NULL;
ALTER TABLE person ALTER COLUMN is_dismissed SET NOT NULL;
ALTER TABLE person ALTER COLUMN is_deleted SET NOT NULL;
ALTER TABLE person ALTER COLUMN affiliation SET NOT NULL;

ALTER TABLE yandex_group ALTER COLUMN staff_id SET NOT NULL;
ALTER TABLE yandex_group ALTER COLUMN deleted SET NOT NULL;

ALTER TABLE yandex_group ADD CONSTRAINT yandex_group_staff_id_unique_constraint UNIQUE (staff_id);

DROP INDEX IF EXISTS yandex_group_staff_id_unique;

CREATE INDEX IF NOT EXISTS yandex_group_membership_role_project_id ON yandex_group_membership (role, project_id);
CREATE INDEX IF NOT EXISTS yandex_group_deleted ON yandex_group (deleted);
CREATE INDEX IF NOT EXISTS person_dismissed_deleted ON person (is_dismissed, is_deleted);
CREATE INDEX IF NOT EXISTS person_group_membership_group_id ON person_group_membership (group_id);

COMMIT;