START TRANSACTION;

CREATE TABLE IF NOT EXISTS campaign_resource
(
    id BIGSERIAL PRIMARY KEY,
    campaign_id BIGINT NOT NULL REFERENCES campaign (id) ON DELETE CASCADE ON UPDATE CASCADE,
    resource_id BIGINT NOT NULL REFERENCES resource (id) ON DELETE CASCADE ON UPDATE CASCADE,
    required BOOLEAN NOT NULL DEFAULT FALSE,
    default_amount BIGINT,
    "default" BOOLEAN NOT NULL DEFAULT FALSE,
    settings JSONB NOT NULL DEFAULT '{}',
    UNIQUE (campaign_id, resource_id)
);

COMMIT;