START TRANSACTION;

CREATE TABLE IF NOT EXISTS provider_group
(
    id          BIGSERIAL PRIMARY KEY,
    name        SHORT_TEXT NOT NULL,
    description TEXT       NOT NULL,
    campaign_id BIGINT     NOT NULL REFERENCES campaign (id) ON DELETE CASCADE ON UPDATE CASCADE,
    priority    INT        NOT NULL,
    settings    JSONB      NOT NULL
);

CREATE INDEX IF NOT EXISTS provider_group_campaign_id ON provider_group (campaign_id);
CREATE INDEX IF NOT EXISTS provider_group_priority ON provider_group (priority);

CREATE TABLE IF NOT EXISTS provider_group_report
(
    provider_group_id BIGINT PRIMARY KEY REFERENCES provider_group (id) ON DELETE CASCADE ON UPDATE CASCADE,
    report            JSONB  NOT NULL
);

COMMIT;
