START TRANSACTION;

CREATE TABLE bot_configuration_reserve
(
    id                  BIGSERIAL PRIMARY KEY,
    service_id          BIGINT NOT NULL REFERENCES service (id) ON UPDATE CASCADE ON DELETE CASCADE,
    campaign_id         BIGINT NOT NULL REFERENCES campaign (id) ON UPDATE CASCADE ON DELETE CASCADE,
    big_order_id        BIGINT NOT NULL REFERENCES bot_big_order (id) ON UPDATE CASCADE ON DELETE CASCADE,
    location_segment_id BIGINT NOT NULL REFERENCES segment (id) ON UPDATE CASCADE ON DELETE CASCADE,
    configuration_id    BIGINT NOT NULL REFERENCES bot_configuration (id) ON UPDATE CASCADE ON DELETE CASCADE,
    quantity            BIGINT NOT NULL CHECK (quantity > 0),
    UNIQUE (service_id, campaign_id, big_order_id, location_segment_id, configuration_id)
);

COMMIT;
