START TRANSACTION;

ALTER TABLE bot_big_order
    ADD COLUMN configs JSONB NOT NULL DEFAULT '[]';

ALTER TABLE bot_big_order
    ALTER COLUMN config DROP NOT NULL;

UPDATE bot_big_order
SET configs = to_jsonb(array(
        select jsonb_build_object('id', value, 'typeCode', 'forecast', 'categoryCode', 'new', 'locationKey', key)
        from jsonb_each((config ->> 0)::jsonb)));

ALTER TABLE bot_big_order
    ALTER COLUMN configs DROP DEFAULT;

COMMIT;
