START TRANSACTION;

CREATE TABLE IF NOT EXISTS bot_campaign_group (
    id                          BIGSERIAL PRIMARY KEY,
    key                         short_text NOT NULL,
    bot_pre_order_issue_key     short_text NOT NULL,
    name                        short_text NOT NULL,
    active                      BOOLEAN NOT NULL DEFAULT FALSE,
    UNIQUE(key),
    UNIQUE(name)
);

CREATE TABLE IF NOT EXISTS bot_campaign_group_big_order (
    bot_campaign_group_id               BIGINT NOT NULL REFERENCES bot_campaign_group (id) ON UPDATE CASCADE ON DELETE CASCADE,
    bot_big_order_id                    BIGINT NOT NULL REFERENCES bot_big_order (id) ON UPDATE CASCADE ON DELETE CASCADE,
    UNIQUE (bot_big_order_id),
    UNIQUE (bot_campaign_group_id, bot_big_order_id)
);

CREATE TABLE IF NOT EXISTS bot_campaign_group_campaign (
    bot_campaign_group_id               BIGINT NOT NULL REFERENCES bot_campaign_group (id) ON UPDATE CASCADE ON DELETE CASCADE,
    campaign_id                         BIGINT NOT NULL REFERENCES campaign (id) ON UPDATE CASCADE ON DELETE CASCADE,
    UNIQUE (bot_campaign_group_id, campaign_id),
    UNIQUE (campaign_id)
);

INSERT INTO bot_campaign_group(key, name, active, bot_pre_order_issue_key) SELECT 'order2019', 'Заказ на 2019', FALSE, bot_pre_order_issue_key FROM campaign WHERE key = 'aug2018';
INSERT INTO bot_campaign_group(key, name, active, bot_pre_order_issue_key) SELECT 'order2020_aug', 'Заказ на 2020, август', FALSE, bot_pre_order_issue_key FROM campaign WHERE key = 'aug2019';
INSERT INTO bot_campaign_group(key, name, active, bot_pre_order_issue_key) SELECT 'order2020_feb', 'Заказ на 2020, февраль', FALSE, bot_pre_order_issue_key FROM campaign WHERE key = 'feb2020';
INSERT INTO bot_campaign_group(key, name, active, bot_pre_order_issue_key) SELECT 'order2021', 'Заказ на 2021', TRUE, bot_pre_order_issue_key FROM campaign WHERE key = 'aug2020';

INSERT INTO bot_campaign_group(key, name, active, bot_pre_order_issue_key) VALUES ('orderUnknown', 'Unknown order', FALSE, '');

INSERT INTO bot_campaign_group_big_order(bot_campaign_group_id, bot_big_order_id) SELECT bcg.id, cbo.big_order_id FROM bot_campaign_group bcg, campaign c JOIN campaign_big_order cbo ON c.id = cbo.campaign_id AND c.key = 'aug2018' WHERE bcg.key = 'order2019';
INSERT INTO bot_campaign_group_big_order(bot_campaign_group_id, bot_big_order_id) SELECT bcg.id, cbo.big_order_id FROM bot_campaign_group bcg, campaign c JOIN campaign_big_order cbo ON c.id = cbo.campaign_id AND c.key = 'aug2019' WHERE bcg.key = 'order2020';
INSERT INTO bot_campaign_group_big_order(bot_campaign_group_id, bot_big_order_id) SELECT bcg.id, cbo.big_order_id FROM bot_campaign_group bcg, campaign c JOIN campaign_big_order cbo ON c.id = cbo.campaign_id AND c.key = 'aug2020' WHERE bcg.key = 'order2021';

INSERT INTO bot_campaign_group_big_order(bot_campaign_group_id, bot_big_order_id)
SELECT DISTINCT bcg.id, cbo.big_order_id FROM bot_campaign_group bcg, campaign c JOIN campaign_big_order cbo ON c.id = cbo.campaign_id AND c.key not in ('aug2020', 'aug2019', 'aug2018', 'feb2020') WHERE bcg.key = 'orderUnknown';

INSERT INTO bot_campaign_group_campaign(bot_campaign_group_id, campaign_id) SELECT bcg.id, c.id FROM bot_campaign_group bcg, campaign c WHERE bcg.key = 'order2019' AND c.key in ('aug2018');
INSERT INTO bot_campaign_group_campaign(bot_campaign_group_id, campaign_id) SELECT bcg.id, c.id FROM bot_campaign_group bcg, campaign c WHERE bcg.key = 'order2020_aug' AND c.key in ('aug2019');
INSERT INTO bot_campaign_group_campaign(bot_campaign_group_id, campaign_id) SELECT bcg.id, c.id FROM bot_campaign_group bcg, campaign c WHERE bcg.key = 'order2020_feb' AND c.key in ('feb2020');
INSERT INTO bot_campaign_group_campaign(bot_campaign_group_id, campaign_id) SELECT bcg.id, c.id FROM bot_campaign_group bcg, campaign c WHERE bcg.key = 'order2021' AND c.key in ('aug2020');

INSERT INTO bot_campaign_group_campaign(bot_campaign_group_id, campaign_id) SELECT bcg.id, c.id FROM bot_campaign_group bcg, campaign c WHERE bcg.key = 'orderUnknown' AND c.key not in ('aug2020', 'aug2019', 'aug2018', 'feb2020');

ALTER TABLE bot_pre_order ADD COLUMN bot_campaign_group_id BIGINT REFERENCES bot_campaign_group(id) ON UPDATE CASCADE ON DELETE CASCADE;

ALTER TABLE bot_pre_order DROP CONSTRAINT IF EXISTS bot_pre_order_campaign_id_bot_big_order_id_project_id_servi_key;

ALTER TABLE bot_pre_order ADD UNIQUE(bot_campaign_group_id, bot_big_order_id, project_id, service_id, bot_big_order_config_id, group_key, server_id);

UPDATE bot_pre_order AS bpo
SET bot_campaign_group_id = bcgc.bot_campaign_group_id
FROM bot_campaign_group_campaign bcgc
WHERE bcgc.campaign_id = bpo.campaign_id;

ALTER TABLE bot_pre_order ALTER COLUMN campaign_id DROP NOT NULL;
ALTER TABLE bot_pre_order ALTER COLUMN bot_campaign_group_id SET NOT NULL;

ALTER TABLE campaign ALTER COLUMN bot_pre_order_issue_key DROP NOT NULL;

COMMIT;
