START TRANSACTION;

CREATE TABLE IF NOT EXISTS bot_synced_pre_order
(
    id                  BIGINT PRIMARY KEY,
    big_order_id        BIGINT     NOT NULL REFERENCES bot_big_order (id) ON UPDATE CASCADE ON DELETE CASCADE,
    big_order_config_id BIGINT     NOT NULL,
    category_code       short_text NOT NULL,
    status_id           BIGINT     NOT NULL,
    server_id           BIGINT REFERENCES bot_configuration (id) ON UPDATE CASCADE ON DELETE CASCADE,
    server_quantity     BIGINT,
    storage_id          BIGINT REFERENCES bot_configuration (id) ON UPDATE CASCADE ON DELETE CASCADE,
    storage_quantity    BIGINT,
    oebs_service_id     BIGINT     NOT NULL,
    ticket_id           short_text,
    customer_comment    text,
    responsible         short_text NOT NULL,
    components          jsonb,
    deleted             BOOLEAN    NOT NULL DEFAULT FALSE,
    abc_service_id      BIGINT,
    upgrades_cost       BIGINT     NOT NULL DEFAULT 0
);

CREATE INDEX IF NOT EXISTS bot_synced_pre_order_big_order_config_id_idx ON bot_synced_pre_order (big_order_config_id);


INSERT INTO bot_synced_pre_order (id, big_order_id, big_order_config_id, category_code, status_id, server_id, server_quantity, storage_id,
                                  storage_quantity, oebs_service_id, ticket_id, customer_comment, responsible, components, abc_service_id)
SELECT po.id,
       po.bot_big_order_id,
       po.bot_big_order_config_id,
       'new',
       CASE WHEN po.status = 'DRAFTED' THEN 1 WHEN po.status = 'ORDERED' THEN 2 ELSE 3 END,
       po.server_id,
       po.server_quantity,
       po.storage_id,
       po.storage_quantity,
       0,
       c.bot_pre_order_issue_key,
       po.group_key,
       'robot-di-bot-prod',
       '[]',
       s.abc_service_id
FROM bot_pre_order po
         JOIN campaign c ON c.id = po.campaign_id
         JOIN service s ON s.id = po.service_id;

ALTER TABLE bot_pre_order
    ADD CONSTRAINT bot_pre_order_bot_synced_pre_order_id_fkey
        FOREIGN KEY (id)
            REFERENCES bot_synced_pre_order (id)
            ON DELETE CASCADE ON UPDATE CASCADE;

COMMIT;
