START TRANSACTION;

CREATE TABLE IF NOT EXISTS servers_remainder (
    id BIGSERIAL PRIMARY KEY,
    service_id BIGINT NOT NULL REFERENCES service(id) ON UPDATE CASCADE ON DELETE CASCADE,
    segment_id BIGINT NOT NULL REFERENCES segment(id) ON UPDATE CASCADE ON DELETE CASCADE,
    group_key short_text NOT NULL,
    bot_campaign_group_id BIGINT NOT NULL REFERENCES bot_campaign_group(id) ON UPDATE CASCADE ON DELETE CASCADE,
    server_id BIGINT,
    storage_id BIGINT,
    upgrade BOOLEAN NOT NULL,
    server_count REAL NOT NULL,
    storage_count REAL NOT NULL,
    price REAL NOT NULL
);

CREATE UNIQUE INDEX IF NOT EXISTS servers_remainder_server_storage_null_unique_idx
ON servers_remainder(service_id, segment_id, group_key, bot_campaign_group_id)
WHERE server_id IS NULL AND storage_id IS NULL;

CREATE UNIQUE INDEX IF NOT EXISTS servers_remainder_server_null_unique_idx
ON servers_remainder(service_id, segment_id, group_key, bot_campaign_group_id, storage_id)
WHERE server_id IS NULL;

CREATE UNIQUE INDEX IF NOT EXISTS servers_remainder_storage_null_unique_idx
ON servers_remainder(service_id, segment_id, group_key, bot_campaign_group_id, server_id)
WHERE storage_id IS NULL;

COMMIT;
