START TRANSACTION;

ALTER TABLE service ADD COLUMN IF NOT EXISTS resources_mapping_bean_name short_text;

CREATE OR REPLACE FUNCTION array_sort (ANYARRAY)
RETURNS ANYARRAY LANGUAGE SQL IMMUTABLE
AS $$
SELECT ARRAY(SELECT unnest($1) ORDER BY 1)
$$;

CREATE TABLE IF NOT EXISTS resources_model_mapping
(
    id                          BIGSERIAL        PRIMARY KEY,
    resource_id                 BIGINT           NOT NULL REFERENCES resource (id) ON UPDATE CASCADE ON DELETE CASCADE,
    segment_ids                 BIGINT[]         NOT NULL,
    campaign_id                 BIGINT           NOT NULL REFERENCES campaign (id) ON UPDATE CASCADE ON DELETE CASCADE,
    numerator                   BIGINT           CHECK ((numerator IS NOT NULL AND numerator >= 0) OR skip),
    denominator                 BIGINT           CHECK ((denominator IS NOT NULL AND denominator > 0) OR skip),
    external_resource_id        UUID             CHECK (external_resource_id IS NOT NULL OR skip),
    external_resource_unit_key  short_text       CHECK (external_resource_unit_key IS NOT NULL OR skip),
    skip                        BOOLEAN          NOT NULL
);

CREATE UNIQUE INDEX IF NOT EXISTS resources_model_mapping_unique_non_skip
    ON resources_model_mapping
        (resource_id, array_sort(segment_ids), campaign_id, external_resource_id)
    WHERE external_resource_id IS NOT NULL;

CREATE UNIQUE INDEX IF NOT EXISTS resources_model_mapping_unique_skip
    ON resources_model_mapping
        (resource_id, array_sort(segment_ids), campaign_id)
    WHERE external_resource_id IS NULL;

CREATE INDEX IF NOT EXISTS resources_model_mapping_resource_id_campaign_id
    ON resources_model_mapping
        (resource_id, campaign_id);

ALTER TABLE quota_request_change ADD COLUMN IF NOT EXISTS amount_allocating BIGINT;

UPDATE quota_request_change SET amount_allocating = amount_allocated;

ALTER TABLE quota_request_change ALTER COLUMN amount_allocating SET DEFAULT 0;

ALTER TABLE quota_request_change ALTER COLUMN amount_allocating SET NOT NULL;

ALTER TABLE quota_request_change
ADD CONSTRAINT valid_quota_request_change_amount_allocating
CHECK (amount_allocating >= 0);

COMMIT;
