START TRANSACTION;

CREATE TABLE IF NOT EXISTS delivery
(
    service_id  BIGINT NOT NULL REFERENCES service(id) ON UPDATE CASCADE ON DELETE CASCADE,
    request_id BIGINT NOT NULL REFERENCES quota_request (id) ON UPDATE CASCADE ON DELETE CASCADE,
    unique_id UUID PRIMARY KEY NOT NULL,
    author_id BIGINT NOT NULL REFERENCES person (id) ON UPDATE CASCADE,
    author_uid BIGINT NOT NULL REFERENCES person (uid) ON UPDATE CASCADE,
    abc_service_id BIGINT NOT NULL,
    campaign_id BIGINT NOT NULL REFERENCES campaign (id) ON UPDATE CASCADE ON DELETE CASCADE,
    created_at TIMESTAMP NOT NULL,
    resolved_at TIMESTAMP,
    external_resources JSONB NOT NULL,
    internal_resources JSONB NOT NULL,
    delivery_results JSONB NOT NULL,
    resolved BOOLEAN NOT NULL
);

CREATE INDEX IF NOT EXISTS delivery_resolved ON delivery (service_id, request_id, resolved);

COMMIT;
