START TRANSACTION;

CREATE TABLE base_resource_type (
    id bigserial PRIMARY KEY,
    key short_text NOT NULL,
    name short_text NOT NULL,
    service_id bigint NOT NULL REFERENCES service(id) ON UPDATE CASCADE ON DELETE CASCADE,
    resource_type resource_type NOT NULL,
    UNIQUE (key)
);

CREATE INDEX IF NOT EXISTS base_resource_type_service_id_idx ON base_resource_type(service_id);

CREATE TABLE base_resource (
    id bigserial PRIMARY KEY,
    key short_text NOT NULL,
    name short_text NOT NULL,
    base_resource_type_id bigint NOT NULL REFERENCES base_resource_type(id) ON UPDATE CASCADE ON DELETE CASCADE,
    segment_ids bigint[] NOT NULL,
    UNIQUE (key)
);

CREATE UNIQUE INDEX IF NOT EXISTS base_resource_type_segments_unique_idx
    ON base_resource (base_resource_type_id, array_sort(segment_ids));

CREATE TABLE base_resource_mapping (
    id bigserial PRIMARY KEY,
    base_resource_id bigint NOT NULL REFERENCES base_resource(id) ON UPDATE CASCADE ON DELETE CASCADE,
    campaign_id bigint NOT NULL REFERENCES campaign(id) ON UPDATE CASCADE ON DELETE CASCADE,
    big_order_id bigint NOT NULL REFERENCES bot_big_order(id) ON UPDATE CASCADE ON DELETE CASCADE,
    service_id bigint NOT NULL REFERENCES service(id) ON UPDATE CASCADE ON DELETE CASCADE,
    relation JSONB NOT NULL
);

CREATE INDEX IF NOT EXISTS base_resource_mapping_campaign_order_resource_idx ON base_resource_mapping(campaign_id, big_order_id, base_resource_id);
CREATE INDEX IF NOT EXISTS base_resource_mapping_service_idx ON base_resource_mapping(service_id);
CREATE INDEX IF NOT EXISTS base_resource_mapping_base_resource_idx ON base_resource_mapping(base_resource_id);
CREATE INDEX IF NOT EXISTS base_resource_mapping_order_idx ON base_resource_mapping(big_order_id);

CREATE TABLE base_resource_limit (
    id bigserial PRIMARY KEY,
    base_resource_id bigint NOT NULL REFERENCES base_resource(id) ON UPDATE CASCADE ON DELETE CASCADE,
    campaign_id bigint NOT NULL REFERENCES campaign(id) ON UPDATE CASCADE ON DELETE CASCADE,
    big_order_id bigint NOT NULL REFERENCES bot_big_order(id) ON UPDATE CASCADE ON DELETE CASCADE,
    service_id bigint NOT NULL REFERENCES service(id) ON UPDATE CASCADE ON DELETE CASCADE,
    limit_value bigint NOT NULL,
    UNIQUE(campaign_id, big_order_id, base_resource_id, service_id)
);

CREATE INDEX IF NOT EXISTS base_resource_limit_service_idx ON base_resource_limit(service_id);
CREATE INDEX IF NOT EXISTS base_resource_limit_base_resource_idx ON base_resource_limit(base_resource_id);
CREATE INDEX IF NOT EXISTS base_resource_limit_order_idx ON base_resource_limit(big_order_id);

COMMIT;
