START TRANSACTION;

ALTER TABLE bot_configuration_reserve
ADD COLUMN storage_id BIGINT REFERENCES bot_configuration(id) ON UPDATE CASCADE ON DELETE CASCADE;

ALTER TABLE bot_configuration_reserve
ADD COLUMN storage_quantity BIGINT CHECK (storage_id IS NULL OR storage_id IS NOT NULL AND storage_quantity IS NOT NULL AND storage_quantity >= 0);

ALTER TABLE bot_configuration_reserve
DROP CONSTRAINT bot_configuration_reserve_service_id_campaign_id_big_order__key;

CREATE UNIQUE INDEX bot_configuration_reserve_storage_null
ON bot_configuration_reserve (service_id, campaign_id, big_order_id, location_segment_id, configuration_id)
WHERE storage_id IS NULL;

CREATE UNIQUE INDEX bot_configuration_reserve_storage_not_null
ON bot_configuration_reserve (service_id, campaign_id, big_order_id, location_segment_id, configuration_id, storage_id)
WHERE storage_id IS NOT NULL;

COMMIT;
