START TRANSACTION;

CREATE TABLE quota_request_base_change
(
  id                    BIGSERIAL PRIMARY KEY,
  quota_request_id      BIGINT NOT NULL REFERENCES quota_request (id) ON UPDATE CASCADE ON DELETE CASCADE,
  big_order_id          BIGINT NOT NULL REFERENCES bot_big_order (id) ON UPDATE CASCADE ON DELETE CASCADE,
  base_resource_id      BIGINT NOT NULL REFERENCES base_resource (id) ON UPDATE CASCADE ON DELETE CASCADE,
  amount                BIGINT NOT NULL CHECK (amount >= 0),
  amount_by_service     JSONB NOT NULL,
  UNIQUE (quota_request_id, big_order_id, base_resource_id)
);

CREATE INDEX IF NOT EXISTS quota_request_base_change_big_order_id_idx ON quota_request_base_change(big_order_id);
CREATE INDEX IF NOT EXISTS quota_request_base_change_base_resource_id_idx ON quota_request_base_change(base_resource_id);

ALTER TYPE resource_type
    RENAME TO _resource_type;

CREATE TYPE resource_type AS ENUM ('ENUMERABLE', 'MEMORY', 'MONEY', 'POWER', 'STORAGE', 'TRAFFIC', 'BINARY_TRAFFIC', 'PROCESSOR', 'RUBLE_BUDGET', 'MESSAGE_TRAFFIC', 'STORAGE_BASE');

ALTER TABLE resource
    ALTER COLUMN resource_type TYPE resource_type USING resource_type :: text :: resource_type;

ALTER TABLE base_resource_type
    ALTER COLUMN resource_type TYPE resource_type USING resource_type :: text :: resource_type;

DROP TYPE _resource_type;

COMMIT;
