START TRANSACTION;

CREATE TYPE resolve_status AS ENUM ('IN_PROCESS', 'IN_ALLOCATING_PROCESS', 'RESOLVED');

ALTER TABLE delivery
    ADD COLUMN IF NOT EXISTS resolve_status resolve_status NOT NULL DEFAULT 'IN_PROCESS';

CREATE INDEX IF NOT EXISTS delivery_resolve_status ON delivery (service_id, request_id, resolve_status);

UPDATE delivery SET resolve_status = 'RESOLVED' WHERE resolved IS TRUE;

COMMIT;
