JUNIT5()

INCLUDE(${ARCADIA_ROOT}/intranet/dispenser/dispenser-service/server/server.inc)

USE_RECIPE(antiadblock/postgres_local/recipe/recipe --port 54321 --user dispenser --db_name dispenser --disable-fsync)
INCLUDE(${ARCADIA_ROOT}/antiadblock/postgres_local/recipe/postgresql_bin.inc)
DEPENDS(
    antiadblock/postgres_local/recipe
)

PEERDIR(
    intranet/dispenser/dispenser-service/server/standalone/src/test
)

JDK_VERSION(17)

JAVAC_FLAGS(
    -parameters
)

KOTLINC_FLAGS(
    -java-parameters
)

WITH_KOTLIN()

JAVA_SRCS(SRCDIR ../test/java ru/yandex/qe/dispenser/ws/**/*.java)
JAVA_SRCS(SRCDIR ../test/java ru/yandex/qe/dispenser/ws/**/*.kt)

JVM_ARGS(
    -ea
    -Dspring.profiles.active=development,secondary,sqldao,migration
    -Dhierarchy.update.delay.initial=100000000
    -Dr.y.q.d.d.l.LotsManager.period.initial=100000000
    -Dr.y.q.d.d.e.EntityLifetimeManager.period.initial=3600000
    -Dcache.refresh.scheduler.initial.delay.seconds=100000000
    -Djetty.ServerConnector.port=8084
    -Dlocal-logging
)

#FORK_TESTS() SPLIT_FACTOR(3)

REQUIREMENTS(
    cpu:8
    ram:32
)

SIZE(LARGE)
TAG(ya:fat ya:force_sandbox ya:sandbox_coverage)

NO_LINT()

END()
