package ru.yandex.qe.dispenser;

import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.protocol.HttpContext;
import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.hitman.tvm.TvmConstants;
import ru.yandex.qe.http.aspects.HttpAspect;

@ParametersAreNonnullByDefault
public class TvmServiceTicketAspect implements HttpAspect {

    @NotNull
    private final Supplier<String> serviceTicketSupplier;

    public TvmServiceTicketAspect(final Supplier<String> serviceTicketSupplier) {
        this.serviceTicketSupplier = serviceTicketSupplier;
    }

    @Override
    public void beforeInvoke(final HttpHost httpHost, final HttpRequest httpRequest, final HttpContext httpContext) {
        httpRequest.addHeader(TvmConstants.TVM_SERVICE_HEADER_NAME, serviceTicketSupplier.get());
    }

    @Override
    public void afterInvoke(final HttpResponse httpResponse, final HttpHost httpHost, final HttpRequest httpRequest,
                            final HttpContext httpContext) {

    }

    @Override
    public void onFail(final Exception exception, final HttpHost httpHost, final HttpRequest httpRequest,
                       final HttpContext httpContext) {

    }
}
