package ru.yandex.qe.dispenser;

import java.util.function.Supplier;

import javax.annotation.ParametersAreNonnullByDefault;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.http.aspects.HttpAspect;
import ru.yandex.qe.http.aspects.HttpAspectFactory;

@ParametersAreNonnullByDefault
public class TvmServiceTicketAspectFactory implements HttpAspectFactory {

    @NotNull
    private final TvmServiceTicketAspect tvmServiceTicketAspect;

    public TvmServiceTicketAspectFactory(final Supplier<String> serviceTicketSupplier) {
        tvmServiceTicketAspect = new TvmServiceTicketAspect(serviceTicketSupplier);
    }

    @Override
    public HttpAspect getAspect() {
        return tvmServiceTicketAspect;
    }
}
