package ru.yandex.qe.dispenser.metrics;

import java.lang.management.ManagementFactory;
import java.lang.management.OperatingSystemMXBean;
import java.lang.reflect.Method;

import javax.annotation.PostConstruct;
import javax.inject.Inject;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;

import ru.yandex.qe.dispenser.solomon.SolomonHolder;

@Component
public class FileDescriptorRatioMetrics {

    public static final Logger LOG = LoggerFactory.getLogger(FileDescriptorRatioMetrics.class);

    @Inject
    private SolomonHolder solomonHolder;

    @PostConstruct
    public void init() {
        try {
            OperatingSystemMXBean osMxBean = ManagementFactory.getOperatingSystemMXBean();
            Class<?> targetClass = Class.forName("com.sun.management.UnixOperatingSystemMXBean");
            if (!targetClass.isInstance(osMxBean)) {
                return;
            }
            Method getMaxFileDescriptorCount = targetClass
                    .getDeclaredMethod("getMaxFileDescriptorCount");
            Method getOpenFileDescriptorCount = targetClass
                    .getDeclaredMethod("getOpenFileDescriptorCount");
            solomonHolder.getRootRegistry().lazyGaugeDouble("os.fd_ratio", () -> {
                try {
                    long openCount = (Long) getOpenFileDescriptorCount.invoke(osMxBean);
                    long maxCount = (Long) getMaxFileDescriptorCount.invoke(osMxBean);
                    if (maxCount == 0L) {
                        return 1.0d;
                    }
                    return (double) openCount / (double) maxCount;
                } catch (Exception ex) {
                    LOG.warn("Failed to fill FileDescriptorRatioMetrics", ex);
                    return 0.0d;
                }
            });
        } catch (Exception e) {
            LOG.warn("Failed to setup FileDescriptorRatioMetrics", e);
        }
    }

}
