package ru.yandex.qe.dispenser.passport;

import javax.annotation.Nullable;

/**
 * User: ortemij
 * Date: 28.09.12
 * Time: 19:52
 */
public class Session {

    private final Long userId;
    private final String login;

    private final boolean needRenew;
    private final String cookieValue;
    private final int expires;
    private final String domain;
    private final boolean isHttpOnly;
    private final boolean isValid;

    public Session(final Long userId, final String login, @Nullable final String cookieValue, final boolean needRenew,
                   final int expires, @Nullable final String domain, final boolean httpOnly, final boolean isValid) {
        this.userId = userId;
        this.login = login;
        this.cookieValue = cookieValue;
        this.needRenew = needRenew;
        this.expires = expires;
        this.domain = domain;
        this.isHttpOnly = httpOnly;
        this.isValid = isValid;
    }

    public Session(final Long userId, final String login) {
        this(userId, login, null, false, -1, null, true, true);
    }

    public Session(final Long userId, final String login, final boolean isValid) {
        this(userId, login, null, false, -1, null, true, isValid);
    }

    public Long getUserId() {
        return userId;
    }

    public String getLogin() {
        return login;
    }

    public boolean isNeedRenew() {
        return needRenew;
    }

    public int getExpires() {
        return expires;
    }

    @Nullable
    public String getCookieValue() {
        return cookieValue;
    }

    @Nullable
    public String getDomain() {
        return domain;
    }

    public boolean isHttpOnly() {
        return isHttpOnly;
    }

    public boolean isValid() {
        return isValid;
    }
}

