package ru.yandex.qe.dispenser.passport;

/**
 * User: ortemij
 * Date: 28.09.12
 * Time: 19:52
 */
public class SslSession {

    private final Long userId;
    private final String login;

    private final boolean needRenew;
    private final boolean valid;
    private final boolean secure;


    public SslSession(final Long userId, final String login, final boolean needRenew, final boolean valid, final boolean secure) {
        this.userId = userId;
        this.login = login;
        this.needRenew = needRenew;
        this.valid = valid;
        this.secure = secure;
    }

    public static SslSession invalid() {
        return new SslSession(null, null, false, false, false);
    }

    public Long getUserId() {
        return userId;
    }

    public String getLogin() {
        return login;
    }

    public boolean isNeedRenew() {
        return needRenew;
    }

    public boolean isValid() {
        return valid;
    }

    public boolean isSecure() {
        return secure;
    }
}

