package ru.yandex.qe.dispenser.passport.security;

import java.io.IOException;

import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

import org.springframework.security.web.authentication.ui.DefaultLoginPageGeneratingFilter;
import org.springframework.web.filter.GenericFilterBean;

/**
 * User: madrider
 * Date: 17.04.13 14:59
 */

public class LoginRedirectOnPassportFilter extends GenericFilterBean {
    @Override
    public void doFilter(final ServletRequest request, final ServletResponse response, final FilterChain chain) throws IOException, ServletException {
        final HttpServletRequest req = (HttpServletRequest) request;

        String uri = req.getRequestURI();
        final int pathParamIndex = uri.indexOf(';');
        if (pathParamIndex > 0) {
            // strip everything after the first semi-colon
            uri = uri.substring(0, pathParamIndex);
        }

        if (("".equals(req.getContextPath()) && uri.endsWith(DefaultLoginPageGeneratingFilter.DEFAULT_LOGIN_PAGE_URL)
                || uri.endsWith(req.getContextPath() + DefaultLoginPageGeneratingFilter.DEFAULT_LOGIN_PAGE_URL))) {
            final HttpServletResponse resp = (HttpServletResponse) response;
            resp.sendRedirect("https://passport.yandex-team.ru/passport?mode=auth&retpath=/");
        }
        chain.doFilter(request, response);
    }
}
