package ru.yandex.qe.dispenser.passport.util;

import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;

import org.apache.commons.lang3.tuple.ImmutablePair;

/**
 * Established by terry
 * on 15.03.14.
 */
public class PassportSecurityUtils {

    public static final String YA_SESSION_ID_COOKIE = "session_id";

    private final static ThreadLocal<ImmutablePair<String, String>> refreshHeader = new ThreadLocal<>();

    private PassportSecurityUtils() {
    }

    public static String getRemoteAddress(final HttpServletRequest request) {
        final String xForwardedFor = request.getHeader("X-Forwarded-For");
        if (xForwardedFor != null) {
            return xForwardedFor.split(",")[0].trim();
        }
        return request.getRemoteAddr();
    }

    public static String findYaSessionCookie(final HttpServletRequest request) {
        final Cookie[] cookies = request.getCookies();
        if (cookies != null) {
            for (final Cookie cookie : cookies) {
                if (YA_SESSION_ID_COOKIE.equalsIgnoreCase(cookie.getName())) {
                    return cookie.getValue();
                }
            }
        }
        return null;
    }

    public static void saveRefreshHeader(final String key, final String value) {
        refreshHeader.set(ImmutablePair.of(key, value));
    }

    public static void resetRefreshHeader() {
        refreshHeader.set(null);
    }

    public static ImmutablePair<String, String> getRefreshHeader() {
        return refreshHeader.get();
    }


}
