package ru.yandex.qe.dispenser.quartz.monitoring;

import java.util.Objects;
import java.util.Set;

public class JobStatus {

    private final String jobName;
    private final String groupName;
    private final Set<TriggerStatus> triggerStatuses;

    public JobStatus(final String jobName, final String groupName, final Set<TriggerStatus> triggerStatuses) {
        this.jobName = jobName;
        this.groupName = groupName;
        this.triggerStatuses = triggerStatuses;
    }

    public String getJobName() {
        return jobName;
    }

    public String getGroupName() {
        return groupName;
    }

    public Set<TriggerStatus> getTriggerStatuses() {
        return triggerStatuses;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final JobStatus jobStatus = (JobStatus) o;
        return Objects.equals(jobName, jobStatus.jobName) &&
                Objects.equals(groupName, jobStatus.groupName) &&
                Objects.equals(triggerStatuses, jobStatus.triggerStatuses);
    }

    @Override
    public int hashCode() {
        return Objects.hash(jobName, groupName, triggerStatuses);
    }

    @Override
    public String toString() {
        return "JobStatus{" +
                "jobName='" + jobName + '\'' +
                ", groupName='" + groupName + '\'' +
                ", triggerStatuses=" + triggerStatuses +
                '}';
    }

}
