package ru.yandex.qe.dispenser.quartz.monitoring;

import org.quartz.JobDetail;
import org.quartz.JobKey;
import org.quartz.SchedulerException;
import org.quartz.SchedulerListener;
import org.quartz.Trigger;
import org.quartz.TriggerKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import ru.yandex.qe.dispenser.solomon.SolomonHolder;
import ru.yandex.monlib.metrics.labels.Labels;
import ru.yandex.monlib.metrics.primitives.Rate;
import ru.yandex.monlib.metrics.registry.MetricRegistry;

public class MonitoringSchedulerListener implements SchedulerListener {

    private static final Logger LOG = LoggerFactory.getLogger(MonitoringSchedulerListener.class);
    private static final String ERROR_RATE = "scheduler.scheduler_error_rate";
    private static final String SCHEDULER = "scheduler";

    private final String schedulerName;
    private final Rate errorRate;

    public MonitoringSchedulerListener(final String schedulerName, final SolomonHolder solomonHolder) {
        this.schedulerName = schedulerName;
        final MetricRegistry rootRegistry = solomonHolder.getRootRegistry();
        this.errorRate = rootRegistry.rate(ERROR_RATE, Labels.of(SCHEDULER, schedulerName));
    }

    @Override
    public void jobScheduled(final Trigger trigger) {
    }

    @Override
    public void jobUnscheduled(final TriggerKey triggerKey) {
    }

    @Override
    public void triggerFinalized(final Trigger trigger) {
    }

    @Override
    public void triggerPaused(final TriggerKey triggerKey) {
    }

    @Override
    public void triggersPaused(final String triggerGroup) {
    }

    @Override
    public void triggerResumed(final TriggerKey triggerKey) {
    }

    @Override
    public void triggersResumed(final String triggerGroup) {
    }

    @Override
    public void jobAdded(final JobDetail jobDetail) {
    }

    @Override
    public void jobDeleted(final JobKey jobKey) {
    }

    @Override
    public void jobPaused(final JobKey jobKey) {
    }

    @Override
    public void jobsPaused(final String jobGroup) {
    }

    @Override
    public void jobResumed(final JobKey jobKey) {
    }

    @Override
    public void jobsResumed(final String jobGroup) {
    }

    @Override
    public void schedulerError(final String msg, final SchedulerException cause) {
        LOG.error("Error in " + schedulerName + " scheduler: " + msg, cause);
        errorRate.inc();
    }

    @Override
    public void schedulerInStandbyMode() {
    }

    @Override
    public void schedulerStarted() {
        LOG.info("Scheduler {} started", schedulerName);
    }

    @Override
    public void schedulerStarting() {
        LOG.info("Scheduler {} starting...", schedulerName);
    }

    @Override
    public void schedulerShutdown() {
        LOG.info("Scheduler {} shut down", schedulerName);
    }

    @Override
    public void schedulerShuttingdown() {
        LOG.info("Scheduler {} shutting down...", schedulerName);
    }

    @Override
    public void schedulingDataCleared() {
    }

}
