package ru.yandex.qe.dispenser.quartz.monitoring;

import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayDeque;
import java.util.Deque;

public class MovingAverage {

    private final Deque<Long> window = new ArrayDeque<>();
    private final int windowSize;

    private BigDecimal sum = BigDecimal.ZERO;
    private volatile long average = 0L;

    public MovingAverage(final int windowSize) {
        if (windowSize <= 0) {
            throw new IllegalArgumentException("Window size must be positive");
        }
        this.windowSize = windowSize;
    }

    public synchronized void update(final long value) {
        sum = sum.add(BigDecimal.valueOf(value));
        window.add(value);
        if (window.size() > windowSize) {
            sum = sum.subtract(BigDecimal.valueOf(window.remove()));
        }
        if (!window.isEmpty()) {
            average = sum.divide(BigDecimal.valueOf(window.size()), 10, RoundingMode.HALF_UP).longValue();
        } else {
            average = 0L;
        }
    }

    public long getAverage() {
        return average;
    }

}
