package ru.yandex.qe.dispenser.quartz.monitoring;

import java.util.Objects;
import java.util.Set;

public class QuartzStatus {

    private final Set<SchedulerStatus> schedulerStatuses;
    private final long stoppedSchedulers;
    private final long triggersWithError;

    public QuartzStatus(final Set<SchedulerStatus> schedulerStatuses, final long stoppedSchedulers, final long triggersWithError) {
        this.schedulerStatuses = schedulerStatuses;
        this.stoppedSchedulers = stoppedSchedulers;
        this.triggersWithError = triggersWithError;
    }

    public Set<SchedulerStatus> getSchedulerStatuses() {
        return schedulerStatuses;
    }

    public long getStoppedSchedulers() {
        return stoppedSchedulers;
    }

    public long getTriggersWithError() {
        return triggersWithError;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final QuartzStatus that = (QuartzStatus) o;
        return stoppedSchedulers == that.stoppedSchedulers &&
                triggersWithError == that.triggersWithError &&
                Objects.equals(schedulerStatuses, that.schedulerStatuses);
    }

    @Override
    public int hashCode() {
        return Objects.hash(schedulerStatuses, stoppedSchedulers, triggersWithError);
    }

    @Override
    public String toString() {
        return "QuartzStatus{" +
                "schedulerStatuses=" + schedulerStatuses +
                ", stoppedSchedulers=" + stoppedSchedulers +
                ", triggersWithError=" + triggersWithError +
                '}';
    }

}
