package ru.yandex.qe.dispenser.quartz.monitoring;

import java.util.Objects;
import java.util.Set;

public class SchedulerStatus {

    private final String schedulerName;
    private final boolean schedulerStarted;
    private final Set<JobStatus> jobStatuses;

    public SchedulerStatus(final String schedulerName, final boolean schedulerStarted, final Set<JobStatus> jobStatuses) {
        this.schedulerName = schedulerName;
        this.schedulerStarted = schedulerStarted;
        this.jobStatuses = jobStatuses;
    }

    public String getSchedulerName() {
        return schedulerName;
    }

    public boolean isSchedulerStarted() {
        return schedulerStarted;
    }

    public Set<JobStatus> getJobStatuses() {
        return jobStatuses;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final SchedulerStatus that = (SchedulerStatus) o;
        return schedulerStarted == that.schedulerStarted &&
                Objects.equals(schedulerName, that.schedulerName) &&
                Objects.equals(jobStatuses, that.jobStatuses);
    }

    @Override
    public int hashCode() {
        return Objects.hash(schedulerName, schedulerStarted, jobStatuses);
    }

    @Override
    public String toString() {
        return "SchedulerStatus{" +
                "schedulerName='" + schedulerName + '\'' +
                ", schedulerStarted=" + schedulerStarted +
                ", jobStatuses=" + jobStatuses +
                '}';
    }

}
