package ru.yandex.qe.dispenser.quartz.monitoring;

import org.quartz.Trigger;

public enum TriggerState {

    NONE(true),
    NORMAL(true),
    PAUSED(true),
    COMPLETE(true),
    ERROR(false),
    BLOCKED(true),
    ;

    private final boolean ok;

    TriggerState(final boolean ok) {
        this.ok = ok;
    }

    public boolean isOk() {
        return ok;
    }

    public static TriggerState from(final Trigger.TriggerState value) {
        switch (value) {
            case NONE:
                return NONE;
            case NORMAL:
                return NORMAL;
            case PAUSED:
                return PAUSED;
            case COMPLETE:
                return COMPLETE;
            case ERROR:
                return ERROR;
            case BLOCKED:
                return BLOCKED;
            default:
                throw new IllegalArgumentException("Unsupported trigger state: " + value);
        }
    }

}
