package ru.yandex.qe.dispenser.quartz.monitoring;

import java.util.Objects;

public class TriggerStatus {

    private final String triggerName;
    private final String groupName;
    private final TriggerState state;

    public TriggerStatus(final String triggerName, final String groupName, final TriggerState state) {
        this.triggerName = triggerName;
        this.groupName = groupName;
        this.state = state;
    }

    public String getTriggerName() {
        return triggerName;
    }

    public String getGroupName() {
        return groupName;
    }

    public TriggerState getState() {
        return state;
    }

    @Override
    public boolean equals(final Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || getClass() != o.getClass()) {
            return false;
        }
        final TriggerStatus that = (TriggerStatus) o;
        return Objects.equals(triggerName, that.triggerName) &&
                Objects.equals(groupName, that.groupName) &&
                state == that.state;
    }

    @Override
    public int hashCode() {
        return Objects.hash(triggerName, groupName, state);
    }

    @Override
    public String toString() {
        return "TriggerStatus{" +
                "triggerName='" + triggerName + '\'' +
                ", groupName='" + groupName + '\'' +
                ", state=" + state +
                '}';
    }

}
