package ru.yandex.qe.dispenser.tvm;

import org.springframework.beans.factory.annotation.Value;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Conditional;
import org.springframework.context.annotation.Configuration;

import ru.yandex.qe.hitman.tvm.qloud.QloudTvmService;

@Configuration
public class DeployTvmSpringConfiguration {

    /**
     * Overrides the {@link ru.yandex.qe.hitman.tvm.qloud.QloudTvmServiceImpl} definition from
     * {@link ru.yandex.qe.hitman.tvm.QloudTvmSpringConfiguration}
     * */
    @Bean
    @Conditional(DeployCondition.class)
    public QloudTvmService qloudTvmService(@Value("#{environment.TVMTOOL_LOCAL_AUTHTOKEN}") final String tvmToolToken,
                                           @Value("#{environment.DEPLOY_TVM_TOOL_URL}") final String tvmToolAddress,
                                           @Value("${tvm.id}") final String tvmId) {
        return new DeployTvmServiceImpl(tvmId, tvmToolAddress, tvmToolToken);
    }
}
