package ru.yandex.qe.dispenser.ws;

import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;

import org.jetbrains.annotations.NotNull;

import ru.yandex.qe.dispenser.domain.hierarchy.Role;

@Retention(RetentionPolicy.RUNTIME)
@Target(ElementType.METHOD)
public @interface Access {
    String PROJECT_KEY = ProjectService.PROJECT_KEY;
    String SERVICE_KEY = ServiceService.SERVICE_KEY;
    String ENTITY_SPEC_KEY = EntitySpecService.ENTITY_SPEC_KEY;

    @NotNull
    Role[] role() default {};

    boolean parent() default false;

    boolean serviceAdmin() default false;

    boolean serviceTrustee() default false;

    boolean dispenserAdmin() default false;
}
